;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   LED7SEG_1.inc
;;  Version: 1.20, Updated on 2011/6/28 at 6:9:36
;;  Generated by PSoC Designer 5.1.2306
;;
;;  DESCRIPTION:  Assembler declarations for the GLCD user module interface.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2011. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"

;;----------------------------------------------------------
;;  The Digit Drive Pins variable is formatted as follows;
;;     VALUE[15:12]  => First digit location
;;     VALUE[11:8]   => Digit count
;;     VALUE[7:0]    => Digit drive mask 
;;----------------------------------------------------------

LED7SEG_1_SegmentPort:    equ   0x3
LED7SEG_1_DigitPort:      equ   0x4
LED7SEG_1_DigitMask:      equ   (0x40f & 0x00FF )


LED7SEG_1_DigitPortDR:    equ   PRT4DR
LED7SEG_1_DigitPortDM0:   equ   PRT4DM0
LED7SEG_1_DigitPortDM1:   equ   PRT4DM1
LED7SEG_1_DigitPortDM2:   equ   PRT4DM2

LED7SEG_1_SegmentPortDR:  equ   PRT3DR
LED7SEG_1_SegmentPortDM0: equ   PRT3DM0
LED7SEG_1_SegmentPortDM1: equ   PRT3DM1
LED7SEG_1_SegmentPortDM2: equ   PRT3DM2


LED7SEG_1_DigitCnt:       equ   ((0x40f>>8)&0x0F)
LED7SEG_1_DigitDimCnt:    equ   (LED7SEG_1_DigitCnt<<1)
LED7SEG_1_DigitDrive:     equ   1
LED7SEG_1_SegmentDrive:   equ   1
LED7SEG_1_FirstDigit:     equ   ((0x40f>>12)&0x0F)


LED7SEG_1_TIMER_PRESENT:  equ   1


IF(1)                      // Active High Digit Drive
LED7SEG_1_DigitOff:       equ   ~LED7SEG_1_DigitMask
ELSE                                   // Active Low Digit Drive
LED7SEG_1_DigitOff:       equ   LED7SEG_1_DigitMask
ENDIF

// Initial segment pattern
LED7SEG_1_SegmentInit:    equ   0x00

LED7SEG_1_DigitShadow:    equ  Port_4_Data_SHADE

LED7SEG_1_ScanFlag:       equ   0x80      // If set, scan
LED7SEG_1_DimEnable:      equ   0x40      // Dim Enable  
LED7SEG_1_DimFlag:        equ   0x20      // If set, Blanking 
LED7SEG_1_DimNow:         equ   0x60      // If set, Blank this sequence

LED7SEG_1_CntMask:        equ   0x0F      // Digit count mask


LED7SEG_1_Dig1Mask:    equ   ((0x01<<(LED7SEG_1_FirstDigit+0))& 0x00FF )
LED7SEG_1_Dig2Mask:    equ   ((0x01<<(LED7SEG_1_FirstDigit+1))& 0x00FF )
LED7SEG_1_Dig3Mask:    equ   ((0x01<<(LED7SEG_1_FirstDigit+2))& 0x00FF )
LED7SEG_1_Dig4Mask:    equ   ((0x01<<(LED7SEG_1_FirstDigit+3))& 0x00FF )
LED7SEG_1_Dig5Mask:    equ   ((0x01<<(LED7SEG_1_FirstDigit+4))& 0x00FF )
LED7SEG_1_Dig6Mask:    equ   ((0x01<<(LED7SEG_1_FirstDigit+5))& 0x00FF )
LED7SEG_1_Dig7Mask:    equ   ((0x01<<(LED7SEG_1_FirstDigit+6))& 0x00FF )
LED7SEG_1_Dig8Mask:    equ   ((0x01<<(LED7SEG_1_FirstDigit+7))& 0x00FF )


;------------------------------------------------------
;  The following is valid only if timer is present.
;------------------------------------------------------
IF (LED7SEG_1_TIMER_PRESENT)
LED7SEG_1_CONTROL_REG_START_BIT:           equ 0x01    ; Control register start bit
LED7SEG_1_INT_REG:                         equ 0x0e1
LED7SEG_1_INT_MASK:                        equ 0x01
LED7SEG_1_CONTROL_REG:                     equ 0x23   ; Control register
 
ENDIF

;------------------------------------------------------
;  Register Address Constants for  LED7SEG_1
;------------------------------------------------------

;------------------------------------------------------
;  Macros for  LED7SEG_1
;------------------------------------------------------





; end of file LED7SEG_1.inc
