;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: I2CHW.inc
;;   Version: 1.90, Updated on 2011/6/28 at 6:9:30
;;  Generated by PSoC Designer 5.1.2306
;;
;;  DESCRIPTION: Assembler declarations for the I2Cs user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2011. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

I2CHW_MUM_SEL: equ 2h

I2CHW_SLAVE: equ 1
I2CHW_MSTR:  equ 2
I2CHW_MMS:   equ 4

;I2CHW_SLAVE_ADDR:                          equ   @Slave_Addrh       ;Permanent Slave Address
I2CHW_ADDR_REG_PRESENT:                     equ   0                  ;CY8C28X45 have 1 always while all other have 0
I2CHW_AUTO_ADDR_CHECK:                      equ   0                  ;CY8C28X45 may have this 0 or 1 while all other have 0
I2CHW_USED_I2C_BLOCK:                       equ   0                  ;CY8C28X45 have 0 for I2C Controller_0 and 1 for I2C Controller_1, other have 0

;--------------------------------------------------
;   I2CHW API Constants
;--------------------------------------------------

I2CHW_INT_REG:                             equ 0x0de
I2CHW_INT_MASK:                            equ 0x01



;-----------------
; Misc. equates
;-----------------

;I2CHW_RsrcStatus byte, Status Bit definitions
I2CHW_RD_NOERR:                             equ 0x1   ;read completed without errors
I2CHW_RD_OVERFLOW:                          equ 0x2   ;master read more bytes than were contained in read buffer
I2CHW_RD_COMPLETE:                          equ 0x4   ;last read transaction complete
I2CHW_READFLASH:                            equ 0x8   ;set- next read will use flash read buffer, clear- next read will use ram read buffer
I2CHW_WR_NOERR:                             equ 0x10  ;write completed without errors
I2CHW_WR_OVERFLOW:                          equ 0x20  ;received bytes exceeded write buffer length
I2CHW_WR_COMPLETE:                          equ 0x40  ;Master uses this definition, slave uses that below.
I2CHW_ISR_NEW_ADDR:                         equ 0x40  ;New addre received (can infer that previous transaction is complete)
I2CHW_ISR_ACTIVE:                           equ 0x80  ;ISR for I2C_slave is is active


fI2C_NAKnextWr:                             equ 0x04  ;flag to tell slave to nak next byte from master


;=== I2C equates ===



I2CHW_SCR:                                  equ d7h    ; I2C Enable Master/Slave Block Operation

I2CM_BUSERR:    equ 0x80
I2CM_LOSTARB:   equ 0x40
I2C_STOP_ST:    equ 0x20
I2C_ACKOUT:     equ 0x10
I2C_ADDRIN:     equ 0x08
I2C_TX:         equ 0x04 ;compliment is RX
I2C_LST_BIT:    equ 0x02
I2C_BYTE_COMPL: equ 0x01

I2CHW_CFG:                                  equ d6h    ; I2C Configuration RegisterI2C

I2C_BUSERRIE:   equ 0x20
I2C_STOPIE:     equ 0x10
I2C_CLKR1:      equ 0x08
I2C_CLKR0:      equ 0x04
I2C_M_EN:       equ 0x02
I2C_S_EN:       equ 0x01

I2CHW_MSCR:                                 equ d9h    ; I2C Master Status and Control

I2CM_BUSBUSY:   equ 0x08
I2CM_MASTEROP:  equ 0x04
I2CM_RESTRT:    equ 0x02
I2CM_SNDSTRT:   equ 0x01

I2CHW_DR:                                   equ d8h    ; I2C Status and Control Register

IF(I2CHW_ADDR_REG_PRESENT) ;Applicable for CY8C28X45
I2CHW_ADDR:                  equ @ADDR_ADDRh                     ; I2C Address
ENDIF

;Equates used as conditional compile keys


I2CHW_READ_BUFTYPE:                         equ 0x0

I2CHW_READ_FLASH:                           equ I2CHW_READ_BUFTYPE & 0x01

I2CHW_24MHZ_FIX:                            equ 0x0

I2CHW_THROTTLE_CLK_RATE:                    equ I2CHW_24MHZ_FIX & 0x01

I2CHW_POLLING_ENABLE:                       equ 0x0

I2CHW_POLLED_PROCESS:                       equ I2CHW_POLLING_ENABLE & 0x01

;I2C_(status and control) reg write macro
;----------------------------------------------------
;  I2C_SCR and I2C_MSCR reg write macro
;
;  Use the following macros to write to the I2C_SCR register
;  Usage:    SetI2C_MSCR WRITE_VALUE
;            SetI2C_SCR  WRITE_VALUE
;            SetI2C_CFG  WRITE_VALUE
;
;  where WRITE_VALUE is the data to be writen
;
;----------------------------------------------------
; Write to the  I2CHW_SCR register
;
    macro SetI2CHW_SCR

IF I2CHW_THROTTLE_CLK_RATE
        or    F, FLAG_XIO_MASK            ; set bank1
        push  X
        mov   X, A                        ; if data for I2C_SCR was in A save it in X
        mov   A, reg[OSC_CR0]             ;
        push  A
        and   A, ~0x07
        or    A, 0x1
        mov   reg[OSC_CR0], A             ; throttle the clock down to 6Mhz
        and   F, ~FLAG_XIO_MASK           ; set bank0
        mov   A, X                        ; if the operation uses data in A get it out of X
        mov   reg[I2CHW_SCR], @0    ; write data to reg[I2C_SCR]
        or    F, FLAG_XIO_MASK            ; set bank1
        pop   A                           ; restore original clock speed
        mov   reg[OSC_CR0], A
        and   F, ~FLAG_XIO_MASK           ; set bank0
        mov   A, X                        ; if A was data restore it from X now
        pop   X                           ; restore original accumulator
ELSE
        mov   reg[I2CHW_SCR], @0 ; write data to reg[I2C_SCR]
ENDIF
    endm

;
; Write to the  I2CHW_MSCR register
;
    macro SetI2CHW_MSCR

IF I2CHW_THROTTLE_CLK_RATE
        or    F, FLAG_XIO_MASK            ; set bank1
        push  X
        mov   X, A                        ; if data for I2C_SCR was in A save it in X
        mov   A, reg[OSC_CR0]             ;
        push  A
        and   A, ~0x07
        or    A, 0x01
        mov   reg[OSC_CR0], A             ; throttle the clock down to 6Mhz
        and   F, ~FLAG_XIO_MASK           ; set bank0
        mov   A, X                        ; if the operation uses data in A get it out of X
        mov   reg[I2CHW_MSCR], @0   ; write data to reg[I2C_MSCR]
        or    F, FLAG_XIO_MASK            ; set bank1
        pop   A                           ; restore original clock speed
        mov   reg[OSC_CR0], A
        and   F, ~FLAG_XIO_MASK           ; set bank0
        mov   A, X                        ; if A was data restore it from X now
        pop   X                           ; restore original accumulator
ELSE
        mov  reg[I2CHW_MSCR], @0   ; write data to reg[I2C_MSCR]
ENDIF
    endm

;
; SET a bit in the  I2CHW_CFG register
;
    macro BitSetI2CHW_CFG

IF I2CHW_THROTTLE_CLK_RATE
        or    F, FLAG_XIO_MASK            ; set bank1
        push  A
        mov   A, reg[OSC_CR0]             ;
        push  A
        and   A, ~0x07
        or    A, 0x02
        mov   reg[OSC_CR0], A             ; throttle the clock down to 12Mhz
		IF(I2CHW_USED_I2C_BLOCK)
		or    reg[I2CHW_CFG], @0    ; write data to reg[I2C_CFG]
		ELSE
        and   F, ~FLAG_XIO_MASK           ; set bank0
        or    reg[I2CHW_CFG], @0    ; write data to reg[I2C_CFG]
        or    F, FLAG_XIO_MASK            ; set bank1
		ENDIF
        pop   A                           ; restore original clock speed
        mov   reg[OSC_CR0], A
        and   F, ~FLAG_XIO_MASK           ; set bank0
        pop   A                           ; restore original accumulator
ELSE
		IF(I2CHW_USED_I2C_BLOCK)
		or    F, FLAG_XIO_MASK            ; set bank1
        or    reg[I2CHW_CFG], @0    ; write data to reg[I2C_CFG]
		and   F, ~FLAG_XIO_MASK           ; set bank0
		ELSE
		or    reg[I2CHW_CFG], @0    ; write data to reg[I2C_CFG]
		ENDIF
ENDIF
    endm

; CLR a bit in the  I2CHW_CFG register
;
;NOTE: clears the bits set to ONE in the input
;
    macro BitClrI2CHW_CFG

IF I2CHW_THROTTLE_CLK_RATE
        or    F, FLAG_XIO_MASK                    ; set bank1
        push  A
        mov   A, reg[OSC_CR0]                     ;
        push  A
        and   A, ~0x07
        or    A, 0x02
        mov   reg[OSC_CR0], A                     ; throttle the clock down to 12Mhz
		IF(I2CHW_USED_I2C_BLOCK)
		and   reg[I2CHW_CFG], ~@0           ; write data to reg[I2C_CFG]
		ELSE
        and   F, ~FLAG_XIO_MASK                   ; set bank0
        and   reg[I2CHW_CFG], ~@0           ; write data to reg[I2C_CFG]
        or    F, FLAG_XIO_MASK                    ; set bank1
		ENDIF
        pop   A                                   ; restore original clock speed
        mov   reg[OSC_CR0], A
        and   F, ~FLAG_XIO_MASK                   ; set bank0
        pop   A                                   ; restore original accumulator
ELSE
		IF(I2CHW_USED_I2C_BLOCK)
		or    F, FLAG_XIO_MASK                    ; set bank1
        and   reg[I2CHW_CFG], ~@0           ; write data to reg[I2C_CFG]
		and   F, ~FLAG_XIO_MASK                   ; set bank0
		ELSE
		and   reg[I2CHW_CFG], ~@0           ; write data to reg[I2C_CFG]
		ENDIF
ENDIF
    endm

;
;Support either a ret or reti depending on value of a config parameter for polled or interrupt based use
;
    macro I2CHW_SERVICE_RETURN

IF I2CHW_POLLED_PROCESS
        ret                                       ; NOT and ISR so use only a ret to return from poll
ELSE    
        reti                                      ; use reti to return from ISR
ENDIF
    endm


;
;A macro function that calls the poll routine to be used in some of the wait loops that pend on
; states that can only be cleared by execution of the Poll function.
; this code should compile to NULL if the POLL selection is not made.
;
    macro I2CHW_POLL_SERVICE

IF I2CHW_POLLED_PROCESS
        lcall  I2CHW_Poll              ; Call this function repeatedly if we are in a loop
		                                          ; waiting for bStatus BUS_BUSY to clear.  Otherwise
												  ; this is a deadlock condtion
ENDIF
    endm


; end of file I2CHW.inc

