//Library
#include <SevenSeg.h>

//Seven Seg
//SevenSeg disp (10, 9, 8, 7, 6, 11, 12);Defines the segments A-G: SevenSeg(A, B, C, D, E, F, G); Internet bsp variante.
 SevenSeg disp (5, 25, 28, 27, 6, 23, 22); //Defines the segments A-G: SevenSeg(A, B, C, D, E, F, G);



//Constants
const int numOfDigits =4;   
int digitPins [numOfDigits]={13,12,11,10};  //CC(or CA) pins of segment
                                            //13= left seg; 12= left_mittel; 11=right_mittel; 10= right;
const int startBT = 7;
const int changeBT = 8;
const int setBT = 9;
const int dotPoint1=A0;                     //left digit
const int dotPoint2=A1;                     //left_mittel digit
const int dotPoint3=A2;                     //right_mittel digit
const int dotPoint4=A3;                     //right
const int BrakeBT=2;                        //BrakeBT ist für den Interrupt PAUSE/Frage Taster   // ERGÄNZENDE/ERWEITERTE ZEILE(N)AM 25.08.2016 //////////////////////
      
//Variables
String number="0000";
int digit1=0;                           //left digit
int digit2=0;                           //left_mittel digit
int digit3=0;                           //right_mittel digit
int digit4=0;                           //right
int start, change, set;
int setPoint=0;
volatile int buttonState = LOW;
int Sec=0;
int Min=0;
//Useful flags
boolean countFlag=false;
boolean stop_bool = false;

  

void setup() {
  pinMode(startBT,  INPUT_PULLUP);
  pinMode(changeBT, INPUT_PULLUP);
  pinMode(setBT,    INPUT_PULLUP);
  pinMode(dotPoint1, OUTPUT);
  pinMode(dotPoint2, OUTPUT);
  pinMode(dotPoint3, OUTPUT);
  pinMode(dotPoint4, OUTPUT);

  attachInterrupt(0, pause, FALLING);   //für den Interrupt PAUSE/Frage Taster   // ERGÄNZENDE/ERWEITERTE ZEILE(N)AM 25.08.2016 //////////////////////


//Defines the number of digits to be "numOfDigits" and the digit pins to be the elements of the array "digitPins"
disp.setDigitPins ( numOfDigits , digitPins );

//Only for common cathode 7segments
disp.setCommonCathode();

//Control brightness (values 0-100);
disp.setDutyCycle(60);
disp.setTimer(2);
disp.startTimer(); 
}

void loop() 
{
 //Read buttons state
start = digitalRead(startBT);
change = digitalRead(changeBT);
set = digitalRead(setBT);

if (set == LOW && !countFlag)
{
    delay(500);
    if (setPoint < 4)
    {setPoint++;}
    else
    {setPoint=0;}
 }

if (start == LOW && setPoint==0)
{   delay(500);
    if (!countFlag)
    {countFlag=true;}
    else
    {countFlag=false;}
    
}

//left digit        left digit              left digit            left digit

 if (change == LOW && setPoint == 4 && !countFlag)
{  delay(500);
    if (Sec < 9)
    {Sec++;}
    else
    {Sec=0;}   
}
  
//left_mittel digit         left_mittel digit         left_mittel digit          left_mittel digit

if (change == LOW && setPoint == 3 && !countFlag)
{   delay(500);
    if (Sec <= 50)
    {Sec += 10;}
    else
    {Sec = Sec - 50;}
}

//right_mittel digit         right_mittel digi          right_mittel digi           right_mittel digi 
  
if (change == LOW && setPoint == 2 && !countFlag)
{   delay(500);
    if (Min < 9)
    {Min++;}
    else
    {Min=0;}   
}
//right       //right       //right             //right             //right
  
if (change == LOW && setPoint == 1 && !countFlag)
{   delay(500);
    if (Min <= 50)
    {Min += 10;}
    else
    {Min = Min - 50;}
}
 //Control dot points                    //Control dot points                                  //Control dot points

if (setPoint==0)
{ digitalWrite(dotPoint1,LOW);
  digitalWrite(dotPoint2,LOW);
  digitalWrite(dotPoint3,LOW);
  digitalWrite(dotPoint4,LOW);
}
else if (setPoint==4)
{ digitalWrite(dotPoint1,LOW);
  digitalWrite(dotPoint2,LOW);
  digitalWrite(dotPoint3,LOW);
  digitalWrite(dotPoint4,HIGH);
}
else if (setPoint==3)
{ digitalWrite(dotPoint1,LOW);
  digitalWrite(dotPoint2,LOW);
  digitalWrite(dotPoint3,HIGH);
  digitalWrite(dotPoint4,LOW);
}
else if (setPoint==2)
{ digitalWrite(dotPoint1,LOW);
  digitalWrite(dotPoint2,HIGH);
  digitalWrite(dotPoint3,LOW);
  digitalWrite(dotPoint4,LOW);
}
else if (setPoint==1)
{
  digitalWrite(dotPoint1,HIGH);
  digitalWrite(dotPoint2,LOW);
  digitalWrite(dotPoint3,LOW);
  digitalWrite(dotPoint4,LOW);
}



convert_time_to_digit();

delay(1000);      

stepDown();


}//ende LOOP Funktion


void convert_time_to_digit() 
{ digit1 = (int)(Min / 10);
  digit2 = (int)(Min - digit1*10);

  digit3 = (int)(Sec / 10);
  digit4 = (int)(Sec - digit3*10);

  number = String(digit1) + String(digit2) + String(digit3) + String(digit4);

  disp.write(number);

}

void stepDown()                                        
{  if (Sec > 0) 
   {Sec -= 1;} 
   else
    {Sec = 59;                             
    Min -= 1;}
}    // ende StepDown


void pause()
{ if (stop_bool = false) 
  {stop_bool = true;}
  else
  {stop_bool = false;}
}


ISR( TIMER2_COMPA_vect ){
 disp.interruptAction ();
 }






