com_h = openserial(6, "38400,n,8,1"); // Serielle Schnittstelle Parameter

//// Datensatzgröße - Summe der von µC gesendeten Bytes in jedem Datensatz
recBytes = 4; 
// Funktion zum lesen eines Datensatzes aus dem ByteStream
// passend zu den von µC gesendeten Datentypen 
function [col1, col2, col3]= GetRecord(fd)
    col1 = mget(1, 'c', fd); // 'c': char
    col2 = mget(1, 'c', fd); // 'c': char
    col3 = mget(1, 's', fd); // 's': short
endfunction

timeout = 60; // maximale Wartezeit auf erste serielle Daten
scopetime = 10; // Aufzeichnungsdauer
t_start = getdate(); // Startzeit stoppen
t_now = getdate(); // Zeitkontrolle initialisieren
scopeStarted = 0; // Flag zum Umschalten von Wartezeit auf Aufzeichnungsdauer
readBuf = []; // Puffer für gelesenen Bytestrom

res = 'timeout';
while etime(t_now, t_start) < timeout // Wartezeit oder Aufzeichnungsdauer
    t_now = getdate();
    [q,flags]=serialstatus(com_h);
    if q(1) >= recBytes // Datensatz Empfangen

        // Aufzeichnungsdauer initialisieren
        res = 'OK';
        if scopeStarted == 0
            scopeStarted = 1;
            t_start = getdate();
            timeout = scopetime;
        end

        // Bytestream zwischenspeichern
        for i = 1:recBytes;
            readBuf(length(readBuf)+1) = uint8(ascii(readserial(com_h, 1)));
        end      
        
    end
end
disp(res);
closeserial(com_h);

// Bytestream temporär in Binärdatei abspeichern
fh = mopen('readdata.bin', 'wb+');
mput(readBuf, 'c');
mseek(0);
readData = [];

// Datensätze formatiert auslesen
while ~meof(fh) do
    [c1, c2, c3] =  GetRecord(fh);
    readData = [readData; [c1, c2, c3]];
end
mclose(fh);

// Aufzeichnung in Zeitdiagramm darstellen
timetick = 0.004; // Abtastrate des Senders für Skalierung der x-Achse
clf();
t = [0:size(readData, 1) - 1] * timetick;
readData(:,1) = readData(:,1) * 10; // Sensorwert Bereich vergrößern
readData(:,3) = readData(:,3) / 256; // Fixkommazahl normieren
plot2d(t, readData);
xlabel('t[s]');
legend('LinesensorVal', 'RegVal PID', 'RegVal ID Anteil');
xgrid();

