;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   UART.inc
;;  Version: 5.3, Updated on 2010/9/19 at 23:41:9
;;  Generated by PSoC Designer 5.1.1875.0
;;
;;  DESCRIPTION:  Assembler declarations for the UART user module.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

;--------------------------------------------------
; Constants for UART API's
;--------------------------------------------------

;mask value for global int reg bit for TX instance
UART_TX_INT_MASK:                            equ 0x04
UART_TX_INT_REG:                             equ 0x0e1  ;TX interrupt address
UART_RX_INT_MASK:                            equ 0x08  ;mask value for global int reg bit for RX instance
UART_RX_INT_REG:                             equ 0x0e1  ;RX interrupt address

UART_RXBUF_ENABLE:                           equ 1

; Interrupt control masks
UART_ENABLE_RX_INT:                          equ 0x01
UART_DISABLE_RX_INT:                         equ 0x00
UART_ENABLE_TX_INT:                          equ 0x02
UART_DISABLE_TX_INT:                         equ 0x00

UART_INT_MODE_TX_REG_EMPTY:                  equ 0x00
UART_INT_MODE_TX_COMPLETE:                   equ 0x01

UART_RX_IGNORE_BELOW:                        equ 0x20
UART_RX_BUFFER_SIZE:                         equ 0x10
UART_CMD_TERM:                               equ 0xd
UART_DELIMITER:                              equ 0x20
UART_BACKSPACE_ENABLE:                       equ 0x0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       WARNING WARNING WARNING
; The following equates are for backwards
; compatibility only and should not be used
; for new designs.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;------------------------------------
;  Parity masks
;------------------------------------
UART_PARITY_NONE:       equ   00h
UART_PARITY_EVEN:       equ   02h
UART_PARITY_ODD:        equ   06h

;------------------------------------
;  TX Status Register masks
;------------------------------------
UART_TX_COMPLETE:       equ   20h
UART_TX_BUFFER_EMPTY:   equ   10h

;------------------------------------
;  RX Status Register masks
;------------------------------------
UART_RX_ACTIVE:         equ   10h
UART_RX_COMPLETE:       equ   08h
UART_RX_PARITY_ERROR:   equ   80h
UART_RX_OVERRUN_ERROR:  equ   40h
UART_RX_FRAMING_ERROR:  equ   20h
UART_RX_NO_ERROR:       equ   E0h
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;             END WARNING
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;------------------------------------
;  Parity masks
;------------------------------------
UART_PARITY_NONE:                       equ   00h
UART_PARITY_EVEN:                       equ   02h
UART_PARITY_ODD:                        equ   06h

;------------------------------------
;  TX Status Register masks
;------------------------------------
UART_TX_COMPLETE:                       equ   20h
UART_TX_BUFFER_EMPTY:                   equ   10h

;------------------------------------
;  RX Status Register masks
;------------------------------------
UART_RX_ACTIVE:                         equ   10h
UART_RX_COMPLETE:                       equ   08h
UART_RX_REG_FULL:                       equ   08h
UART_RX_PARITY_ERROR:                   equ   80h
UART_RX_OVERRUN_ERROR:                  equ   40h
UART_RX_FRAMING_ERROR:                  equ   20h
UART_RX_ERROR:                          equ   E0h
UART_RX_ENABLE:                         equ   01h

UART_RX_BUF_ERROR:                      equ   F0h  ; Mask for any Rx that may occur.
UART_RX_BUF_OVERRUN:                    equ   10h  ; This indicates the software buffer has
                                                        ; been over run.
UART_RX_BUF_CMDTERM:                    equ   01h  ; Command terminator has been received.

UART_RX_NO_DATA:                        equ   01h
UART_RX_NO_ERROR:                       equ   E0h


;--------------------------------------------------
; Registers Address Constants for UART
;--------------------------------------------------
;---------------------------------
;  Registers used by TX
;---------------------------------
UART_TX_CONTROL_REG:    equ 2bh            ; Control register
UART_TX_SHIFT_REG:  equ 28h               ; TX Shift Register register
UART_TX_BUFFER_REG: equ 29h               ; TX Buffer Register
UART_TX_FUNC_REG:   equ 28h             ; Function register
UART_TX_INPUT_REG:  equ 29h             ; Input register
UART_TX_OUTPUT_REG: equ 2ah             ; Output register

;---------------------------------
;  Registers used by RX
;---------------------------------
UART_RX_CONTROL_REG:    equ 2fh            ; Control register
UART_RX_SHIFT_REG:  equ 2ch               ; RX Shift Register register
UART_RX_BUFFER_REG: equ 2eh               ; RX Buffer Register
UART_RX_FUNC_REG:   equ 2ch             ; Function register
UART_RX_INPUT_REG:  equ 2dh             ; Input register
UART_RX_OUTPUT_REG: equ 2eh             ; Output register

; end of file UART.inc
